﻿// See https://aka.ms/new-console-template for more information

Console.Title = "The color";
Console.ForegroundColor = ConsoleColor.DarkCyan;
Console.BackgroundColor = ConsoleColor.Black;
Console.Beep();


Color colorOne = new Color(0, 255, 100);
Color colorTwo = Color.CreateGreen();

Console.WriteLine($"Color Values: red-{colorOne._red}, green-{colorTwo._green}, blue-{colorOne._blue} ");
Console.WriteLine($"Color Values: red-{colorTwo._red}, green-{colorTwo._green}, blue-{colorTwo._blue} ");
Console.ReadLine();


class Color
{
   public int _red { get; }  //fields 
   public int _green { get; }
   public int _blue { get; }

   public Color(int red, int green, int blue)
   {
      _red = red;
      _green = green;
      _blue = blue;
   }

   public Color() : this(0, 0, 0){}
   
 //  The pedestal also includes some color names, with a set of numbers indicating their specific values for 
 //each channel. These are commonly used colors: White (255, 255, 255), Black (0, 0, 0), Red (255, 0, 0), 
  // Orange (255,165, 0), Yellow (255, 255, 0), Green (0, 128, 0), Blue (0, 0, 255), Purple (128, 0, 128).
   public static Color CreateWhite() => new Color(255, 255, 255);
   public static Color CreateBlack() => new Color(0, 0, 0);
   public static Color CreateRed() => new Color(255, 0, 0);
   public static Color CreateGreen() => new Color(0, 255, 0);
   public static Color CreateBlue() => new Color(0, 0, 255);
   public static Color CreateOrange() => new Color(255, 165, 0);
   public static Color CreateYellow() => new Color(255, 255, 0);
   public static Color CreatePurple() => new Color(128, 0, 128);
   
}
   
   